-- Opens a multiline editbox popup when you type /bug or /suggest

PopupPower.PlugIns.BugAndSuggest = {};

BUG_SUBMITTED_FEEDBACK = BUG_SUBMITTED..": \"%s\"";
SUGGEST_SUBMITTED_FEEDBACK = SUGGEST_SUBMITTED..": \"%s\"";

BUG_POPUP_TEXT = SEND_BUG.."\n"..SUGGEST_TOOLTIP_TEXT;
SUGGEST_POPUP_TEXT = SEND_SUGGEST.."\n"..SUGGEST_TOOLTIP_TEXT;

function PopupPower.PlugIns.BugAndSuggest.Setup()
	
	PopupPower.PlugIns.BugAndSuggest.ReportBug = SlashCmdList["BUG"];
	SlashCmdList["BUG"] = function(msg) 
		ChatEdit_OnEscapePressed(ChatFrameEditBox);
		StaticPopup_Show("BUG");
		local editbox = StaticPopup_GetEditBox("BUG");
		if (editbox and msg) then
			editbox:SetText(msg);
		end
	end;
	
	PopupPower.PlugIns.BugAndSuggest.ReportSuggestion = SlashCmdList["SUGGEST"];
	SlashCmdList["SUGGEST"] = function(msg) 
		ChatEdit_OnEscapePressed(ChatFrameEditBox);
		StaticPopup_Show("SUGGEST");
		local editbox = StaticPopup_GetEditBox("SUGGEST");
		if (editbox and msg) then
			editbox:SetText(msg);
		end
	end;
	
end

StaticPopupDialogs["BUG"] = {
	text = BUG_POPUP_TEXT,
	button1 = SEND_LABEL,
	button2 = CANCEL,
	hasEditBox = 1,
	hasMultiLineEditBox = 1,
	extraWide = 1,
	maxLetters = 255,
	OnAccept = function(button, data2)
		--PopupPower.PlugIns.BugAndSuggest.ReportBug(StaticPopup_GetEditBox("BUG"):GetText(), BUG_SUBMITTED);
		local text = StaticPopup_GetEditBox("BUG"):GetText();
		local testArg = arg1;
		arg1 = BUG_SUBMITTED;	--Set arg1, used for followup UI_INFO_MESSAGE
		ReportBug(text);
		arg1 = testArg;
		DEFAULT_CHAT_FRAME:AddMessage(format(BUG_SUBMITTED_FEEDBACK, text), 1, 1, 0);	-- Fake System Message
	end,
	OnShow = function()
		StaticPopup_GetEditBox("BUG"):SetFocus(1);
	end,
	EditBoxOnEscapePressed = function()
		StaticPopup_GetEditBox("BUG"):ClearFocus()
	end,
	timeout = 0,
	exclusive = 1,
	whileDead = 1
};

StaticPopupDialogs["SUGGEST"] = {
	text = SUGGEST_POPUP_TEXT,
	button1 = SEND_LABEL,
	button2 = CANCEL,
	hasEditBox = 1,
	hasMultiLineEditBox = 1,
	extraWide = 1,
	maxLetters = 255,
	OnAccept = function(button, data2)
		--PopupPower.PlugIns.BugAndSuggest.ReportSuggestion(StaticPopup_GetEditBox("SUGGEST"):GetText(), SUGGEST_SUBMITTED);
		local text = StaticPopup_GetEditBox("SUGGEST"):GetText();
		local testArg = arg1;
		arg1 = SUGGEST_SUBMITTED;	--Set arg1, used for followup UI_INFO_MESSAGE
		ReportSuggestion(text);
		arg1 = testArg;
		DEFAULT_CHAT_FRAME:AddMessage(format(SUGGEST_SUBMITTED_FEEDBACK, text), 1, 1, 0);	-- Fake System Message
	end,
	OnShow = function()
		StaticPopup_GetEditBox("SUGGEST"):SetFocus(1);
	end,
	EditBoxOnEscapePressed = function()
		StaticPopup_GetEditBox("SUGGEST"):ClearFocus()
	end,
	timeout = 0,
	exclusive = 1,
	whileDead = 1
};

